﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using WpfApp1.Structure;
using WpfApp1.Tools;
using static System.Formats.Asn1.AsnWriter;
using System.Xml.Linq;
using Emgu.CV.Structure;
using Emgu.CV;
using Emgu.CV.Util;
using Emgu.CV.CvEnum;
using System.Drawing;
using Microsoft.Win32;
using System.IO;
using System.Text.Json;
using System.Windows.Media.Media3D;
using System.Diagnostics;
using System.Security.Cryptography.Xml;
using System.Windows.Controls.Primitives;
using static Emgu.Util.Platform;
using static System.Net.Mime.MediaTypeNames;
using System.Windows.Threading;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Runtime.CompilerServices;

namespace WpfApp1
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        private void RefreshNodeList()
        {
            cb_node.Items.Clear();
            foreach (Symbol symbol in currentSymbols)
            {
                if (symbol is Node)
                {
                    cb_node.Items.Add(symbol as Node);
                }
            }
        }

        private void RefreshEdgeList()
        {
            cb_edge.Items.Clear();
            foreach (Symbol symbol in currentSymbols)
            {
                if (symbol is Edge)
                {
                    cb_edge.Items.Add(symbol as Edge);
                }
            }
        }

        private void ShowNodeItems(Node? node)
        {
            if (node == null)
            {
                return;
            }
            NodeItems[0].Details[0] = node.id;
            NodeItems[1].Details[0] = node.text;
            NodeItems[2].Details[0] = node.category;
            NodeItems[3].Details[0] = node.color;
            NodeItems[4].Details[0] = (int)node.area;
            NodeItems[5].Details.Clear();
            foreach (Edge edge in node.edges_in)
            {
                NodeItems[5].Details.Add(edge);
            }
            NodeItems[6].Details.Clear();
            foreach (Edge edge in node.edges_out)
            {
                NodeItems[6].Details.Add(edge);
            }
        }

        private void ShowEdgeItems(Edge? edge)
        {
            if (edge == null)
            {
                return;
            }
            EdgeItems[0].Details[0] = edge.id;
            EdgeItems[1].Details[0] = edge.text;
            EdgeItems[2].Details[0] = edge.category;
            EdgeItems[3].Details[0] = edge.color;
            EdgeItems[4].Details[0] = edge.weight;
            EdgeItems[5].Details.Clear() ;
            foreach (Node node in edge.nodes_from)
            {
                EdgeItems[5].Details.Add(node);
            }
            EdgeItems[6].Details.Clear();
            foreach (Node node in edge.nodes_to)
            {
                EdgeItems[6].Details.Add(node);
            }
        }
    }

    public class ListItem : INotifyPropertyChanged
    {
        private string name;
        public string Name
        {
            get => name;
            set
            {
                name = value;
                OnPropertyChanged();
            }
        }

        private ObservableCollection<object> details;
        public ObservableCollection<object> Details
        {
            get => details;
            set
            {
                details = value;
                OnPropertyChanged();
            }
        }

        public event PropertyChangedEventHandler PropertyChanged;

        protected virtual void OnPropertyChanged([CallerMemberName] string propertyName = null)
        {
            PropertyChanged?.Invoke(this, new PropertyChangedEventArgs(propertyName));
        }

        // 构造函数初始化 Details 为 ObservableCollection<object>
        public ListItem()
        {
            Details = new ObservableCollection<object>();
        }

        public ListItem(string name, string? detail=null)
        {
            Name = name;
            Details = new ObservableCollection<object>();
            if (detail != null)
            {
                Details.Add(detail);
            }
        }
    }
}